// Pixel shader input structure
struct PS_INPUT
{
    float4 Position   : POSITION;
    float4 Color	  : COLOR0;
    float2 Texture0   : TEXCOORD0;
};


// Pixel shader output structure
struct PS_OUTPUT
{
    float4 Color   : COLOR0;
};


// Global variables
sampler2D Tex0;
sampler2D Tex1;
float4 Params;

PS_OUTPUT ps_main( in PS_INPUT In )
{
    PS_OUTPUT Out;                             //create an output pixel		
    float4 aColor = tex2D(Tex0, In.Texture0);
    float aBWColor = aColor.r*0.3*0.9 + aColor.g*0.59*0.9 + aColor.b*0.11*0.9;
    
    Out.Color = lerp(aColor, float4(aBWColor, aBWColor, aBWColor, 1), Params[0]);	
    return Out;                                //return output pixel
}

technique Default
{
	pass P0
	{
		PixelShader = compile ps_2_0 ps_main();
	}
}
